﻿© Fluke Calibration. All Rights Reserved.                  MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Compute Power
DATE:                  2011-12-13 13:32:46
AUTHOR:                Fluke Corporation
REVISION:              1.0
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       33
=============================================================================
#
# This subprocedure uses the global variables @Voltage, @Current, and
# @PhaseAngleInDegrees to compute true power.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Compute displacement power factor (DPF).
  1.001  MATH         DPF = COS(@PhaseAngleInDegrees * 0.0174532925)

# Calculate Power.
  1.002  MATH         Power = @Voltage * @Current * DPF

# Format the Power value to two digits.
  1.003  MATH         Power = FMT(Power, "%4.2f")

# Display the calculated values.
  1.004  DISP         Voltage     = [V @Voltage] V
  1.004  DISP         Current     = [V @Current] A
  1.004  DISP         Phase Angle = [V @PhaseAngleInDegrees]°
  1.004  DISP
  1.004  DISP         Computed Power = [V Power] watts.

  1.005  END